
{
  double dist[5] = {209., 409., 0., 0., 0.};
  double time[5] = {0., 0., 0., 0., 0.};
  double dist_err[5] = {0.1, 0.1, 0.1, 0.1, 0.1};
  double err[5];

  TF1 *func1=new TF1("func1","gaus(0)+pol1(3)");
  func1->SetParameter(0,1000.);
  func1->SetParameter(1,180.);
  func1->SetParameter(2,10.);
  func1->SetParameter(3,10.);
  func1->SetParameter(4,0.);
  func1->SetParLimits(0, 1., 1.e6 );
  func1->SetParLimits(1, 150., 250. );
  func1->SetParLimits(2, 0., 1000. );
  func1->SetParLimits(3, 1., 1000. );
  func1->SetParLimits(4, -100., 100. );
  func1->SetLineColor(2);

  TCanvas *c1 = new TCanvas("c1","c1", 800, 600);
  c1->SetLogy(1);
  gStyle->SetStatX( 1.0 );
  gStyle->SetStatY( 1.0 );

  // point 1
  TFile *file1 = new TFile("../data/wave1.root");
  TTree *tree1 = (TTree*)file1->Get("tree");
  TH1D *hist1 = new TH1D("hist1","hist1", 800, 0., 400.);
  tree1->Draw("time>>hist1","0.<time&&time<400.");

  hist1->Fit("func1","","", 0., 260.);
  time[0] = func1->GetParameter(1);
  err[0] = func1->GetParError(1);
  cout << time[0] << " +/- " << err[0] << " ns" << endl;

  hist1->Draw();
  c1->Print("point1.pdf");

  // point 2
  TFile *file2 = new TFile("../data/wave2.root");
  TTree *tree2 = (TTree*)file2->Get("tree");
  TH1D *hist2 = new TH1D("hist2","hist2", 800, 0., 400.);
  tree2->Draw("time>>hist2","0.<time&&time<400.");

  hist2->Fit("func1","","", 0., 260.);
  time[1] = func1->GetParameter(1);
  err[1] = func1->GetParError(1);
  cout << time[1] << " +/- " << err[1] << " ns" << endl;

  hist2->Draw();
  c1->Print("point2.pdf");

  // repeat for 5 points



  // linear fit
  TCanvas *c2 = new TCanvas("c2","c2", 800, 600);

  TGraphErrors *ge1 = new TGraphErrors(2, dist, time, dist_err, err);
  ge1->SetMarkerStyle(20);
  ge1->SetMarkerSize(1.0);
  ge1->Draw("APE");
  TF1 *func2 = new TF1("func2","pol1");
  ge1->Fit("func2");
  gStyle->SetStatX( 0.5 );
  gStyle->SetStatY( 0.9 );
  func2->Draw("same");
  c2->Print("result.pdf");

  double c = 1./func2->GetParameter(1);
  double c_err = func2->GetParError(1) * c*c;

  cout.precision(4);
  cout << "########################################################" << endl;
  cout << "#                                                      #" << endl;
  cout << "#     light speed: ( " << c*1.e-2  << " +/- " ;
  cout.precision(3);
  cout << c_err*1.e-2 << " ) x 10^8 m/s      #" << endl;
  cout << "#                                                      #" << endl;
  cout << "########################################################" << endl;

}
