//#define DISP
#define NSAMPLE 1024
#define OFFSET 13.0

void wave2(int num, int num2){

  int method=1;
  const int nsample=1024;
  float x[NSAMPLE],y[NSAMPLE];
  float x2[1], y2[1];

  char ifile[100],ofile[100],dummy[100],ifile2[100];
  int maxi, rising,maxrange;
  FileStat_t fs,fs2;
  float voltage, time, fitslope, fitconst,fitchi2;

#ifdef DISP
  TCanvas *c1=new TCanvas("c1","c1",800,600);
#endif

  //***Output root file***
  sprintf(ofile,"./waveL%d-%d.root",num,num2);
  TFile* wfile = new TFile(ofile, "recreate");
  TTree* wtree = new TTree("tree","tree");
  wtree->Branch("voltage",&voltage,"voltage/F");
  wtree->Branch("time",&time,"time/F");
  wtree->Branch("fitslope",&fitslope,"fitslope/F");
  wtree->Branch("fitconst",&fitconst,"fitconst/F");
  wtree->Branch("fitchi2",&fitchi2,"fitchi2/F");
  wtree->Branch("maxrange",&maxrange,"maxrange/I");
  
  //input text file
  sprintf(ifile,"./ttl-L%d-%d/wave0.txt", num,num2);
  ifstream data(ifile);
  if(gSystem->GetPathInfo(ifile,fs)){
      cout<<"Cannot open file "<<ifile<<endl;
    //continue;
  } else cout<<"Reading "<<ifile<<endl;
  sprintf(ifile2,"./ttl-L%d-%d/wave1.txt",num,num2);
    ifstream data2(ifile2);
    if(gSystem->GetPathInfo(ifile2,fs2)){
        cout<<"Cannot open file "<<ifile2<<endl;
        //continue;
    } else cout<<"Reading "<<ifile2<<endl;

  //***Read file***
  maxi=0;
  maxrange=0;
  rising=maxi;
  int tmp,tmp2;
  string s1, s2;
  int i=0,i1,i2;
  double a = 0.; // section 
  double b = 0.; // slope
  double chi2;
  double halfT = 0.;
  double halfC = 0.;

  int nevents = 0;
  int ngoodevents = 0;
  while( data >> tmp && data2 >> tmp2){
      i1 =2.0*i;
      i2 =2.0*i+1.0;
    x[i1] = i1;
    y[i1] = (float)tmp;
      x[i2] = i2;
      if(tmp2>254){
      y[i2] = (float)tmp2;
      }
      else{
          y[i2] = (float)tmp2 - 2;
      }
	if(i == 0) maxrange = 0;
	if(y[i1]>250) maxrange = maxrange + 1;
      if(y[i2]>250) maxrange = maxrange + 1;
    if(tmp >tmp2){
	if(y[i1]>y[maxi]) maxi=i1;
	}else{
      if(y[i2]>y[maxi]) maxi=i2;
	}

    if (++i == 512 ){ // end of event    
      i = 0;
      nevents++;
      if ( nevents % 1000 == 0) {
        cout << nevents << " events processed, " 
             << ngoodevents << " events filled" << endl;
      }


      //find rising
      if (y[maxi] < OFFSET +2.0) continue; // empty event
      //if (x[maxi] < 300.) continue; // late peak
      for (int j=maxi; j>=0; j--){
	if ( y[j] <= OFFSET+2 ){
	  rising = j;
	  break;
	}
      }

      //**Draw graph***
      TGraph *g1 = new TGraph(1024,x,y);
      TF1 *f1 = new TF1("f1", "[0]+[1]*x");
#ifdef DISP
      g1->Fit("f1", "", "", x[rising]+0.2, x[maxi]-0.2);
#else
      g1->Fit("f1", "QN", "", x[rising]+0.2, x[maxi]-0.2);
#endif
      a = f1->GetParameter(0);
      b = f1->GetParameter(1);
      chi2 = f1->GetChisquare();
      //if ( chi2 > 100.) continue; // bad fitting

      halfC = (y[maxi]-OFFSET)/2.0 + OFFSET;
      halfT = (halfC-a)/b;
      //cout << "half maximum time : " << halfT << " ns" << endl;
      //cout << "half maximum count: " << halfC << endl;

      voltage= halfC;
      time= halfT;
	//time=x[maxi];
      fitslope= b;
      fitconst= a;
      fitchi2= chi2;
	
#ifdef DISP
      c1->cd();
      x2[0] = halfT;
      y2[0] = halfC;
      TGraph *g2 = new TGraph(1,x2,y2);

      g1->GetXaxis()->SetTitle("Time[nsec]");
      g1->GetYaxis()->SetTitle("Flash ADC count [/2nsec]");
      g1->SetMarkerStyle(8);
      g1->SetMarkerSize(1.0);

      g1->Draw("AP*");
      g2->SetMarkerStyle(21);
      g2->SetMarkerColor(2);
      g2->SetMarkerSize(2.0);
      g2->Draw("P");
      f1->Draw("sames");
      c1->Update();
      printf("Type \'q\' to quit.\n");
      printf("Type \'s\' to save.\n");
      char ans[8];
      fgets(ans,8,stdin);
      
      if( *ans == 'q') exit(0);
      if( *ans == 's') c1->Print("evtdisp.png");
      else{
        c1->Clear();
        continue;
      }
      g2->Delete();
#endif
      g1->Delete();
      f1->Delete();
      maxi=0;
      rising=maxi;
      wtree->Fill();
      ngoodevents++;
    } // end of event
  }

  //Write and close output file
  wtree  -> Write();
  wfile  -> Write();
  wfile  -> Close();

}
