//#define DISP
#define NSAMPLE 512
#define OFFSET 13.0

void doublefit(void){

  int method=1;
  const int nsample=512;
  float x[NSAMPLE],y[NSAMPLE];
  float x2[1], y2[1];

  char ifile[100],ofile[100],dummy[100],ifile2[100];
    int maxi, rising,maxrange;
    int max2i,halfT2;
    FileStat_t fs,fs2;
    float voltage, time, fitslope, fitconst,fitchi2;
    float latefitslope, latefitconst, latefitchi2;
    float c,d;

#ifdef DISP
  TCanvas *c1=new TCanvas("c1","c1",800,600);
#endif

  //***Output root file***
  sprintf(ofile,"./waveL%dsati.root", 4);
  TFile* wfile = new TFile(ofile, "recreate");
  TTree* wtree = new TTree("tree","tree");
  wtree->Branch("voltage",&voltage,"voltage/F");
  wtree->Branch("time",&time,"time/F");
  wtree->Branch("fitslope",&fitslope,"fitslope/F");
  wtree->Branch("fitconst",&fitconst,"fitconst/F");
  wtree->Branch("fitchi2",&fitchi2,"fitchi2/F");
  wtree->Branch("latefitslope",&latefitslope,"latefitslope/F");
  wtree->Branch("latefitconst",&latefitconst,"latefitconst/F");
  wtree->Branch("latefitchi2",&latefitchi2,"latefitchi2/F");
  wtree->Branch("maxrange",&maxrange,"maxrange/I");
  
   sprintf(ifile,"./waveL%dsati.txt", 4);
  ifstream data(ifile);
  if(gSystem->GetPathInfo(ifile,fs)){
      cout<<"Cannot open file "<<ifile<<endl;
    //continue;
  } else cout<<"Reading "<<ifile<<endl;
  sprintf(ifile2,"./waveL%dsati.txt", 51);
    ifstream data2(ifile2);
    if(gSystem->GetPathInfo(ifile2,fs2)){
        cout<<"Cannot open file "<<ifile2<<endl;
        //continue;
    } else cout<<"Reading "<<ifile2<<endl;

  //***Read file***
  maxi=0;
  maxrange=0;
  rising=maxi;
  int tmp;
  string s1, s2;
  int i=0;
  double a = 0.; // section 
  double b = 0.; // slope
  double chi2,lchi2;
  double halfT = 0.;
  double halfC = 0.;

  int nevents = 0;
  int ngoodevents = 0;
  while( data >> tmp ){
    x[i] = 2.0*i;
    y[i] = (float)tmp;
	if(i == 0) maxrange = 0;
	if(y[i]>254) maxrange = maxrange + 1;
    if(y[i]>y[maxi]) maxi=i;
      
      max2i = maxi + maxrange;

    if (++i == 512 ){ // end of event    
      i = 0;
      nevents++;
      if ( nevents % 1000 == 0) {
        cout << nevents << " events processed, " 
             << ngoodevents << " events filled" << endl;
      }


      //find rising
      if (y[maxi] < OFFSET +2.0) continue; // empty event
      //if (x[maxi] < 300.) continue; // late peak
      for (int j=maxi; j>=0; j--){
	  if ( y[j] <= OFFSET+2 ){
	  rising = j;
	  break;
	}
      }

      //**Draw graph***
      TGraph *g1 = new TGraph(512,x,y);
      TF1 *f1 = new TF1("f1", "13+[0]*exp([1]*x)");
      TF1 *f2 = new TF1("f2", "13+[0]*exp([1]*x)");
#ifdef DISP
      g1->Fit("f1", "", "", x[rising]+0.2, x[maxi]-0.2);
#else
      g1->Fit("f1", "QN", "", x[rising]+0.2, x[maxi]-0.2);
#endif
      a = f1->GetParameter(0);
      b = f1->GetParameter(1);
      chi2 = f1->GetChisquare();
	//NDF = f1->GetNDF();
      //if ( chi2 > 100.) continue; // bad fitting

      halfC = (y[maxi]-OFFSET)/2.0 + OFFSET;
      halfT = (halfC-a)/b;
      //cout << "half maximum time : " << halfT << " ns" << endl;
      //cout << "half maximum count: " << halfC << endl;
      for(int j2=max2i; j2<=511 ; j2++){
          if(y[j2]<=halfC)
          {
              halfT2 = j2 ;
              break ;
          }
      }
      //g1->Fit("f2","","",x[max2i]+0.2,x[halfT2]-0.2) ;
      g1->Fit("f2","QN","",x[max2i]+0.2,x[halfT2]-0.2) ;
      c = f2->GetParameter(0);
      d = f2->GetParameter(1);
        lchi2= f2->GetChisquare();
      voltage= halfC;
      time = (log(a) -log(c))/(d-b);
      //time= halfT;
	//time=x[maxi];
      fitslope= b;
      fitconst= a;
      fitchi2= chi2;
        latefitslope= d;
        latefitconst= c;
        latefitchi2= lchi2;
	
#ifdef DISP
      c1->cd();
      x2[0] = halfT;
      y2[0] = halfC;
      TGraph *g2 = new TGraph(1,x2,y2);

      g1->GetXaxis()->SetTitle("Time[nsec]");
      g1->GetYaxis()->SetTitle("Flash ADC count [/2nsec]");
      g1->SetMarkerStyle(8);
      g1->SetMarkerSize(1.0);

      g1->Draw("AP*");
      g2->SetMarkerStyle(21);
      g2->SetMarkerColor(2);
      g2->SetMarkerSize(2.0);
      g2->Draw("P");
      c1->Update();
      printf("Type \'q\' to quit.\n");
      printf("Type \'s\' to save.\n");
      char ans[8];
      fgets(ans,8,stdin);
      
      if( *ans == 'q') exit(0);
      if( *ans == 's') c1->Print("evtdisp.png");
      else{
        c1->Clear();
        continue;
      }
      g2->Delete();
#endif
      g1->Delete();
      f1->Delete();
      maxi=0;
      rising=maxi;
      wtree->Fill();
      ngoodevents++;
    } // end of event
  }

  //Write and close output file
  wtree  -> Write();
  wfile  -> Write();
  wfile  -> Close();

}
